#include <bits/stdc++.h>
using namespace std;
using ll = long long;
using ld = long double;
const int N = 2e5 + 20;

int blok;

struct Query{
    ll l,r,idx;
};

bool cmp(Query& a, Query& b){
    if((a.l/blok) != (b.l/blok))return(a.l / blok) < (b.l / blok);
    return ((a.l / blok)&1) ? (a.r < b.r):(a.r > b.r);
}

void expand(ll idx, vector<ll>& arr, map<ll, ll>& freq, set<pair<ll, ll>>& freqSet){
    if(freq[arr[idx]] > 0)freqSet.erase({freq[arr[idx]],arr[idx]});
    freq[arr[idx]]++;
    freqSet.insert({freq[arr[idx]],arr[idx]});
}

void shrink(ll idx, vector<ll>& arr, map<ll, ll>& freq, set<pair<ll, ll>>& freqSet){
    freqSet.erase({freq[arr[idx]], arr[idx]});
    freq[arr[idx]]--;
    if(freq[arr[idx]] > 0)freqSet.insert({freq[arr[idx]],arr[idx]});
}

void solve()
{
    ll n;
    cin >> n;
    vector<ll> a(n);
    for(ll i = 0; i < n; i++)cin >> a[i];
    vector<ll> pref(n);
    pref[0] = a[0];
    for(int i = 1; i < n; i++){
        pref[i]=pref[i-1] + a[i];
    }

    map<ll,ll> mp;
    map<ll,ll> l;
    map<ll,ll> r;
    mp[0] = 1;
    l[0] = -1;
    for(int i = 0; i < n; i++){
        if(mp[pref[i]]==0){
            mp[pref[i]]++;
            l[pref[i]] = i;
        }else{
            mp[pref[i]]++;
            r[pref[i]] = i;
        }
    }
    vector<pair<ll,ll>> q;
    map<ll,ll> vis;
    for(int i = 0; i < n; i++){
        if(mp[pref[i]] > 1 && !vis[pref[i]]){
            q.push_back({l[pref[i]],r[pref[i]]});
            vis[pref[i]] = 1;
        }
    }
    //for(int i = 0; i < q.size(); i++){
    //    cout << q[i].first << " " << q[i].second<< " " ;
    //}
    //cout << "\n";

    ll m = q.size();
    blok = ll(sqrt(n))+1;

    vector<Query> q1(m);
    for(ll i = 0; i < m; i++){
        q1[i] = {q[i].first,q[i].second,i};
    }
    sort(q1.begin(),q1.end(),cmp);

    ll l1 = 0,r1 = -1;
    map<ll,ll> freq;
    set<pair<ll,ll>> freqSet;
    vector<pair<ll,ll>> res(m);

    for(auto query : q1){
        while(r1 < query.r)expand(++r1,a,freq,freqSet);
        while(l1 > query.l)expand(--l1,a,freq,freqSet);
        while(r1 > query.r)shrink(r1--,a,freq,freqSet);
        while(l1 < query.l)shrink(l1++,a,freq,freqSet);
        res[query.idx] = *freqSet.rbegin();
    }

    ll ans = 0;
    for(int i = 0; i < res.size(); i++){
        ans = max(res[i].first,ans);
    }
    cout << ans << "\n";



}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    ll t;
    t = 1;
    //cin >> t;
    while(t--){
        solve();
    }

}